# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_data_source_request import CreateDataSourceRequest
from ..model.create_data_source_response import CreateDataSourceResponse
from ..model.delete_data_source_request import DeleteDataSourceRequest
from ..model.delete_data_source_response import DeleteDataSourceResponse
from ..model.get_data_source_request import GetDataSourceRequest
from ..model.get_data_source_response import GetDataSourceResponse
from ..model.list_data_source_request import ListDataSourceRequest
from ..model.list_data_source_response import ListDataSourceResponse
from ..model.patch_data_source_request import PatchDataSourceRequest
from ..model.patch_data_source_response import PatchDataSourceResponse


class DataSource(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateDataSourceRequest,
               option: Optional[RequestOption] = None) -> CreateDataSourceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateDataSourceResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateDataSourceResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateDataSourceRequest,
                      option: Optional[RequestOption] = None) -> CreateDataSourceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateDataSourceResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateDataSourceResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteDataSourceRequest,
               option: Optional[RequestOption] = None) -> DeleteDataSourceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteDataSourceResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteDataSourceResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteDataSourceRequest,
                      option: Optional[RequestOption] = None) -> DeleteDataSourceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteDataSourceResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteDataSourceResponse)
        response.raw = resp

        return response

    def get(self, request: GetDataSourceRequest, option: Optional[RequestOption] = None) -> GetDataSourceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetDataSourceResponse = JSON.unmarshal(str(resp.content, UTF_8), GetDataSourceResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetDataSourceRequest,
                   option: Optional[RequestOption] = None) -> GetDataSourceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetDataSourceResponse = JSON.unmarshal(str(resp.content, UTF_8), GetDataSourceResponse)
        response.raw = resp

        return response

    def list(self, request: ListDataSourceRequest, option: Optional[RequestOption] = None) -> ListDataSourceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListDataSourceResponse = JSON.unmarshal(str(resp.content, UTF_8), ListDataSourceResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListDataSourceRequest,
                    option: Optional[RequestOption] = None) -> ListDataSourceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListDataSourceResponse = JSON.unmarshal(str(resp.content, UTF_8), ListDataSourceResponse)
        response.raw = resp

        return response

    def patch(self, request: PatchDataSourceRequest, option: Optional[RequestOption] = None) -> PatchDataSourceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: PatchDataSourceResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchDataSourceResponse)
        response.raw = resp

        return response

    async def apatch(self, request: PatchDataSourceRequest,
                     option: Optional[RequestOption] = None) -> PatchDataSourceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: PatchDataSourceResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchDataSourceResponse)
        response.raw = resp

        return response
