# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_data_source_item_request import CreateDataSourceItemRequest
from ..model.create_data_source_item_response import CreateDataSourceItemResponse
from ..model.delete_data_source_item_request import DeleteDataSourceItemRequest
from ..model.delete_data_source_item_response import DeleteDataSourceItemResponse
from ..model.get_data_source_item_request import GetDataSourceItemRequest
from ..model.get_data_source_item_response import GetDataSourceItemResponse


class DataSourceItem(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateDataSourceItemRequest,
               option: Optional[RequestOption] = None) -> CreateDataSourceItemResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateDataSourceItemResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateDataSourceItemResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateDataSourceItemRequest,
                      option: Optional[RequestOption] = None) -> CreateDataSourceItemResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateDataSourceItemResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateDataSourceItemResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteDataSourceItemRequest,
               option: Optional[RequestOption] = None) -> DeleteDataSourceItemResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteDataSourceItemResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteDataSourceItemResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteDataSourceItemRequest,
                      option: Optional[RequestOption] = None) -> DeleteDataSourceItemResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteDataSourceItemResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteDataSourceItemResponse)
        response.raw = resp

        return response

    def get(self, request: GetDataSourceItemRequest,
            option: Optional[RequestOption] = None) -> GetDataSourceItemResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetDataSourceItemResponse = JSON.unmarshal(str(resp.content, UTF_8), GetDataSourceItemResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetDataSourceItemRequest,
                   option: Optional[RequestOption] = None) -> GetDataSourceItemResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetDataSourceItemResponse = JSON.unmarshal(str(resp.content, UTF_8), GetDataSourceItemResponse)
        response.raw = resp

        return response
