# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .dlp_proof_context import DlpProofContext


class DlpDetectModeProofContext(object):
    _types = {
        "detect_mode": int,
        "detect_name": str,
        "proof_contexts": List[DlpProofContext],
        "hit_count": int,
    }

    def __init__(self, d=None):
        self.detect_mode: Optional[int] = None
        self.detect_name: Optional[str] = None
        self.proof_contexts: Optional[List[DlpProofContext]] = None
        self.hit_count: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DlpDetectModeProofContextBuilder":
        return DlpDetectModeProofContextBuilder()


class DlpDetectModeProofContextBuilder(object):
    def __init__(self) -> None:
        self._dlp_detect_mode_proof_context = DlpDetectModeProofContext()

    def detect_mode(self, detect_mode: int) -> "DlpDetectModeProofContextBuilder":
        self._dlp_detect_mode_proof_context.detect_mode = detect_mode
        return self

    def detect_name(self, detect_name: str) -> "DlpDetectModeProofContextBuilder":
        self._dlp_detect_mode_proof_context.detect_name = detect_name
        return self

    def proof_contexts(self, proof_contexts: List[DlpProofContext]) -> "DlpDetectModeProofContextBuilder":
        self._dlp_detect_mode_proof_context.proof_contexts = proof_contexts
        return self

    def hit_count(self, hit_count: int) -> "DlpDetectModeProofContextBuilder":
        self._dlp_detect_mode_proof_context.hit_count = hit_count
        return self

    def build(self) -> "DlpDetectModeProofContext":
        return self._dlp_detect_mode_proof_context
