# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .dlp_policy_hit_proof import DlpPolicyHitProof


class DlpEvidenceDetail(object):
    _types = {
        "keyword_hits": List[str],
        "regular_hits": List[str],
        "sensitive_hits": List[str],
        "file_size_hits": List[str],
        "file_type_hits": List[str],
        "file_name_ext_hits": List[str],
        "trigger_snippets": List[DlpPolicyHitProof],
        "secure_label_hits": List[str],
    }

    def __init__(self, d=None):
        self.keyword_hits: Optional[List[str]] = None
        self.regular_hits: Optional[List[str]] = None
        self.sensitive_hits: Optional[List[str]] = None
        self.file_size_hits: Optional[List[str]] = None
        self.file_type_hits: Optional[List[str]] = None
        self.file_name_ext_hits: Optional[List[str]] = None
        self.trigger_snippets: Optional[List[DlpPolicyHitProof]] = None
        self.secure_label_hits: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DlpEvidenceDetailBuilder":
        return DlpEvidenceDetailBuilder()


class DlpEvidenceDetailBuilder(object):
    def __init__(self) -> None:
        self._dlp_evidence_detail = DlpEvidenceDetail()

    def keyword_hits(self, keyword_hits: List[str]) -> "DlpEvidenceDetailBuilder":
        self._dlp_evidence_detail.keyword_hits = keyword_hits
        return self

    def regular_hits(self, regular_hits: List[str]) -> "DlpEvidenceDetailBuilder":
        self._dlp_evidence_detail.regular_hits = regular_hits
        return self

    def sensitive_hits(self, sensitive_hits: List[str]) -> "DlpEvidenceDetailBuilder":
        self._dlp_evidence_detail.sensitive_hits = sensitive_hits
        return self

    def file_size_hits(self, file_size_hits: List[str]) -> "DlpEvidenceDetailBuilder":
        self._dlp_evidence_detail.file_size_hits = file_size_hits
        return self

    def file_type_hits(self, file_type_hits: List[str]) -> "DlpEvidenceDetailBuilder":
        self._dlp_evidence_detail.file_type_hits = file_type_hits
        return self

    def file_name_ext_hits(self, file_name_ext_hits: List[str]) -> "DlpEvidenceDetailBuilder":
        self._dlp_evidence_detail.file_name_ext_hits = file_name_ext_hits
        return self

    def trigger_snippets(self, trigger_snippets: List[DlpPolicyHitProof]) -> "DlpEvidenceDetailBuilder":
        self._dlp_evidence_detail.trigger_snippets = trigger_snippets
        return self

    def secure_label_hits(self, secure_label_hits: List[str]) -> "DlpEvidenceDetailBuilder":
        self._dlp_evidence_detail.secure_label_hits = secure_label_hits
        return self

    def build(self) -> "DlpEvidenceDetail":
        return self._dlp_evidence_detail
