# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class DlpExecuteEvidence(object):
    _types = {
        "keyword_hits": List[str],
        "regular_hits": List[str],
        "sensitive_hits": List[str],
    }

    def __init__(self, d=None):
        self.keyword_hits: Optional[List[str]] = None
        self.regular_hits: Optional[List[str]] = None
        self.sensitive_hits: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DlpExecuteEvidenceBuilder":
        return DlpExecuteEvidenceBuilder()


class DlpExecuteEvidenceBuilder(object):
    def __init__(self) -> None:
        self._dlp_execute_evidence = DlpExecuteEvidence()

    def keyword_hits(self, keyword_hits: List[str]) -> "DlpExecuteEvidenceBuilder":
        self._dlp_execute_evidence.keyword_hits = keyword_hits
        return self

    def regular_hits(self, regular_hits: List[str]) -> "DlpExecuteEvidenceBuilder":
        self._dlp_execute_evidence.regular_hits = regular_hits
        return self

    def sensitive_hits(self, sensitive_hits: List[str]) -> "DlpExecuteEvidenceBuilder":
        self._dlp_execute_evidence.sensitive_hits = sensitive_hits
        return self

    def build(self) -> "DlpExecuteEvidence":
        return self._dlp_execute_evidence
