# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .simple_user import SimpleUser


class Document(object):
    _types = {
        "token": str,
        "title": str,
        "update_time": int,
        "object_status": int,
        "object_type": int,
        "owner": SimpleUser,
    }

    def __init__(self, d=None):
        self.token: Optional[str] = None
        self.title: Optional[str] = None
        self.update_time: Optional[int] = None
        self.object_status: Optional[int] = None
        self.object_type: Optional[int] = None
        self.owner: Optional[SimpleUser] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DocumentBuilder":
        return DocumentBuilder()


class DocumentBuilder(object):
    def __init__(self) -> None:
        self._document = Document()

    def token(self, token: str) -> "DocumentBuilder":
        self._document.token = token
        return self

    def title(self, title: str) -> "DocumentBuilder":
        self._document.title = title
        return self

    def update_time(self, update_time: int) -> "DocumentBuilder":
        self._document.update_time = update_time
        return self

    def object_status(self, object_status: int) -> "DocumentBuilder":
        self._document.object_status = object_status
        return self

    def object_type(self, object_type: int) -> "DocumentBuilder":
        self._document.object_type = object_type
        return self

    def owner(self, owner: SimpleUser) -> "DocumentBuilder":
        self._document.owner = owner
        return self

    def build(self) -> "Document":
        return self._document
