# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Email(object):
    _types = {
        "id": str,
        "title": str,
        "owner_type": int,
        "create_time": int,
        "owner_user_id": str,
        "owner_address": str,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.title: Optional[str] = None
        self.owner_type: Optional[int] = None
        self.create_time: Optional[int] = None
        self.owner_user_id: Optional[str] = None
        self.owner_address: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "EmailBuilder":
        return EmailBuilder()


class EmailBuilder(object):
    def __init__(self) -> None:
        self._email = Email()

    def id(self, id: str) -> "EmailBuilder":
        self._email.id = id
        return self

    def title(self, title: str) -> "EmailBuilder":
        self._email.title = title
        return self

    def owner_type(self, owner_type: int) -> "EmailBuilder":
        self._email.owner_type = owner_type
        return self

    def create_time(self, create_time: int) -> "EmailBuilder":
        self._email.create_time = create_time
        return self

    def owner_user_id(self, owner_user_id: str) -> "EmailBuilder":
        self._email.owner_user_id = owner_user_id
        return self

    def owner_address(self, owner_address: str) -> "EmailBuilder":
        self._email.owner_address = owner_address
        return self

    def build(self) -> "Email":
        return self._email
