# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .user_id import UserId


class GwCommon(object):
    _types = {
        "locale": str,
        "report_time": int,
        "session_uuid": str,
        "terminal_type": int,
        "user_id": UserId,
        "openplatform_app_id": int,
        "request_id": str,
        "log_id": str,
    }

    def __init__(self, d=None):
        self.locale: Optional[str] = None
        self.report_time: Optional[int] = None
        self.session_uuid: Optional[str] = None
        self.terminal_type: Optional[int] = None
        self.user_id: Optional[UserId] = None
        self.openplatform_app_id: Optional[int] = None
        self.request_id: Optional[str] = None
        self.log_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "GwCommonBuilder":
        return GwCommonBuilder()


class GwCommonBuilder(object):
    def __init__(self) -> None:
        self._gw_common = GwCommon()

    def locale(self, locale: str) -> "GwCommonBuilder":
        self._gw_common.locale = locale
        return self

    def report_time(self, report_time: int) -> "GwCommonBuilder":
        self._gw_common.report_time = report_time
        return self

    def session_uuid(self, session_uuid: str) -> "GwCommonBuilder":
        self._gw_common.session_uuid = session_uuid
        return self

    def terminal_type(self, terminal_type: int) -> "GwCommonBuilder":
        self._gw_common.terminal_type = terminal_type
        return self

    def user_id(self, user_id: UserId) -> "GwCommonBuilder":
        self._gw_common.user_id = user_id
        return self

    def openplatform_app_id(self, openplatform_app_id: int) -> "GwCommonBuilder":
        self._gw_common.openplatform_app_id = openplatform_app_id
        return self

    def request_id(self, request_id: str) -> "GwCommonBuilder":
        self._gw_common.request_id = request_id
        return self

    def log_id(self, log_id: str) -> "GwCommonBuilder":
        self._gw_common.log_id = log_id
        return self

    def build(self) -> "GwCommon":
        return self._gw_common
