# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .param import Param


class GwRequest(object):
    _types = {
        "host": str,
        "path": str,
        "path_params": List[Param],
        "query": str,
        "method": str,
        "user_agent": str,
        "client_ip": str,
        "referer": str,
        "origin": str,
        "header": str,
    }

    def __init__(self, d=None):
        self.host: Optional[str] = None
        self.path: Optional[str] = None
        self.path_params: Optional[List[Param]] = None
        self.query: Optional[str] = None
        self.method: Optional[str] = None
        self.user_agent: Optional[str] = None
        self.client_ip: Optional[str] = None
        self.referer: Optional[str] = None
        self.origin: Optional[str] = None
        self.header: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "GwRequestBuilder":
        return GwRequestBuilder()


class GwRequestBuilder(object):
    def __init__(self) -> None:
        self._gw_request = GwRequest()

    def host(self, host: str) -> "GwRequestBuilder":
        self._gw_request.host = host
        return self

    def path(self, path: str) -> "GwRequestBuilder":
        self._gw_request.path = path
        return self

    def path_params(self, path_params: List[Param]) -> "GwRequestBuilder":
        self._gw_request.path_params = path_params
        return self

    def query(self, query: str) -> "GwRequestBuilder":
        self._gw_request.query = query
        return self

    def method(self, method: str) -> "GwRequestBuilder":
        self._gw_request.method = method
        return self

    def user_agent(self, user_agent: str) -> "GwRequestBuilder":
        self._gw_request.user_agent = user_agent
        return self

    def client_ip(self, client_ip: str) -> "GwRequestBuilder":
        self._gw_request.client_ip = client_ip
        return self

    def referer(self, referer: str) -> "GwRequestBuilder":
        self._gw_request.referer = referer
        return self

    def origin(self, origin: str) -> "GwRequestBuilder":
        self._gw_request.origin = origin
        return self

    def header(self, header: str) -> "GwRequestBuilder":
        self._gw_request.header = header
        return self

    def build(self) -> "GwRequest":
        return self._gw_request
