# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class KeyPerson(object):
    _types = {
        "key_person_id": str,
        "name": str,
        "email": str,
        "avatar_url": str,
    }

    def __init__(self, d=None):
        self.key_person_id: Optional[str] = None
        self.name: Optional[str] = None
        self.email: Optional[str] = None
        self.avatar_url: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "KeyPersonBuilder":
        return KeyPersonBuilder()


class KeyPersonBuilder(object):
    def __init__(self) -> None:
        self._key_person = KeyPerson()

    def key_person_id(self, key_person_id: str) -> "KeyPersonBuilder":
        self._key_person.key_person_id = key_person_id
        return self

    def name(self, name: str) -> "KeyPersonBuilder":
        self._key_person.name = name
        return self

    def email(self, email: str) -> "KeyPersonBuilder":
        self._key_person.email = email
        return self

    def avatar_url(self, avatar_url: str) -> "KeyPersonBuilder":
        self._key_person.avatar_url = avatar_url
        return self

    def build(self) -> "KeyPerson":
        return self._key_person
