# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .list_openapi_log_request import ListOpenapiLogRequest


class ListDataOpenapiLogRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[ListOpenapiLogRequest] = None

    @staticmethod
    def builder() -> "ListDataOpenapiLogRequestBuilder":
        return ListDataOpenapiLogRequestBuilder()


class ListDataOpenapiLogRequestBuilder(object):

    def __init__(self) -> None:
        list_data_openapi_log_request = ListDataOpenapiLogRequest()
        list_data_openapi_log_request.http_method = HttpMethod.POST
        list_data_openapi_log_request.uri = "/open-apis/security_and_compliance/v1/openapi_logs/list_data"
        list_data_openapi_log_request.token_types = {AccessTokenType.TENANT}
        self._list_data_openapi_log_request: ListDataOpenapiLogRequest = list_data_openapi_log_request

    def request_body(self, request_body: ListOpenapiLogRequest) -> "ListDataOpenapiLogRequestBuilder":
        self._list_data_openapi_log_request.request_body = request_body
        self._list_data_openapi_log_request.body = request_body
        return self

    def build(self) -> ListDataOpenapiLogRequest:
        return self._list_data_openapi_log_request
