# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .user import User


class Message(object):
    _types = {
        "open_message_id": str,
        "text": str,
        "open_chat_id": str,
        "chat_name": str,
        "chat_type": int,
        "owner": User,
        "create_time": int,
    }

    def __init__(self, d=None):
        self.open_message_id: Optional[str] = None
        self.text: Optional[str] = None
        self.open_chat_id: Optional[str] = None
        self.chat_name: Optional[str] = None
        self.chat_type: Optional[int] = None
        self.owner: Optional[User] = None
        self.create_time: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MessageBuilder":
        return MessageBuilder()


class MessageBuilder(object):
    def __init__(self) -> None:
        self._message = Message()

    def open_message_id(self, open_message_id: str) -> "MessageBuilder":
        self._message.open_message_id = open_message_id
        return self

    def text(self, text: str) -> "MessageBuilder":
        self._message.text = text
        return self

    def open_chat_id(self, open_chat_id: str) -> "MessageBuilder":
        self._message.open_chat_id = open_chat_id
        return self

    def chat_name(self, chat_name: str) -> "MessageBuilder":
        self._message.chat_name = chat_name
        return self

    def chat_type(self, chat_type: int) -> "MessageBuilder":
        self._message.chat_type = chat_type
        return self

    def owner(self, owner: User) -> "MessageBuilder":
        self._message.owner = owner
        return self

    def create_time(self, create_time: int) -> "MessageBuilder":
        self._message.create_time = create_time
        return self

    def build(self) -> "Message":
        return self._message
