# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .gw_common import GwCommon
from .gw_request import GwRequest
from .gw_response import GwResponse


class SecurityLogError(object):
    _types = {
        "request": GwRequest,
        "response": GwResponse,
        "common": GwCommon,
    }

    def __init__(self, d=None):
        self.request: Optional[GwRequest] = None
        self.response: Optional[GwResponse] = None
        self.common: Optional[GwCommon] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SecurityLogErrorBuilder":
        return SecurityLogErrorBuilder()


class SecurityLogErrorBuilder(object):
    def __init__(self) -> None:
        self._security_log_error = SecurityLogError()

    def request(self, request: GwRequest) -> "SecurityLogErrorBuilder":
        self._security_log_error.request = request
        return self

    def response(self, response: GwResponse) -> "SecurityLogErrorBuilder":
        self._security_log_error.response = response
        return self

    def common(self, common: GwCommon) -> "SecurityLogErrorBuilder":
        self._security_log_error.common = common
        return self

    def build(self) -> "SecurityLogError":
        return self._security_log_error
