# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class TaskStatus(object):
    _types = {
        "failure_reason": str,
        "status_code": int,
    }

    def __init__(self, d=None):
        self.failure_reason: Optional[str] = None
        self.status_code: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TaskStatusBuilder":
        return TaskStatusBuilder()


class TaskStatusBuilder(object):
    def __init__(self) -> None:
        self._task_status = TaskStatus()

    def failure_reason(self, failure_reason: str) -> "TaskStatusBuilder":
        self._task_status.failure_reason = failure_reason
        return self

    def status_code(self, status_code: int) -> "TaskStatusBuilder":
        self._task_status.status_code = status_code
        return self

    def build(self) -> "TaskStatus":
        return self._task_status
