# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class TenantThirdPartyEncryptionApp(object):
    _types = {
        "vendor_name": str,
        "status": int,
        "service_start_time": int,
        "service_end_time": int,
        "config": str,
    }

    def __init__(self, d=None):
        self.vendor_name: Optional[str] = None
        self.status: Optional[int] = None
        self.service_start_time: Optional[int] = None
        self.service_end_time: Optional[int] = None
        self.config: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TenantThirdPartyEncryptionAppBuilder":
        return TenantThirdPartyEncryptionAppBuilder()


class TenantThirdPartyEncryptionAppBuilder(object):
    def __init__(self) -> None:
        self._tenant_third_party_encryption_app = TenantThirdPartyEncryptionApp()

    def vendor_name(self, vendor_name: str) -> "TenantThirdPartyEncryptionAppBuilder":
        self._tenant_third_party_encryption_app.vendor_name = vendor_name
        return self

    def status(self, status: int) -> "TenantThirdPartyEncryptionAppBuilder":
        self._tenant_third_party_encryption_app.status = status
        return self

    def service_start_time(self, service_start_time: int) -> "TenantThirdPartyEncryptionAppBuilder":
        self._tenant_third_party_encryption_app.service_start_time = service_start_time
        return self

    def service_end_time(self, service_end_time: int) -> "TenantThirdPartyEncryptionAppBuilder":
        self._tenant_third_party_encryption_app.service_end_time = service_end_time
        return self

    def config(self, config: str) -> "TenantThirdPartyEncryptionAppBuilder":
        self._tenant_third_party_encryption_app.config = config
        return self

    def build(self) -> "TenantThirdPartyEncryptionApp":
        return self._tenant_third_party_encryption_app
