# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class User(object):
    _types = {
        "user_id": str,
        "name": str,
        "email": str,
        "avatar_url": str,
    }

    def __init__(self, d=None):
        self.user_id: Optional[str] = None
        self.name: Optional[str] = None
        self.email: Optional[str] = None
        self.avatar_url: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "UserBuilder":
        return UserBuilder()


class UserBuilder(object):
    def __init__(self) -> None:
        self._user = User()

    def user_id(self, user_id: str) -> "UserBuilder":
        self._user.user_id = user_id
        return self

    def name(self, name: str) -> "UserBuilder":
        self._user.name = name
        return self

    def email(self, email: str) -> "UserBuilder":
        self._user.email = email
        return self

    def avatar_url(self, avatar_url: str) -> "UserBuilder":
        self._user.avatar_url = avatar_url
        return self

    def build(self) -> "User":
        return self._user
