# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class VaultExportFile(object):
    _types = {
        "name": str,
        "size": str,
        "url": str,
        "download_url": str,
    }

    def __init__(self, d=None):
        self.name: Optional[str] = None
        self.size: Optional[str] = None
        self.url: Optional[str] = None
        self.download_url: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "VaultExportFileBuilder":
        return VaultExportFileBuilder()


class VaultExportFileBuilder(object):
    def __init__(self) -> None:
        self._vault_export_file = VaultExportFile()

    def name(self, name: str) -> "VaultExportFileBuilder":
        self._vault_export_file.name = name
        return self

    def size(self, size: str) -> "VaultExportFileBuilder":
        self._vault_export_file.size = size
        return self

    def url(self, url: str) -> "VaultExportFileBuilder":
        self._vault_export_file.url = url
        return self

    def download_url(self, download_url: str) -> "VaultExportFileBuilder":
        self._vault_export_file.download_url = download_url
        return self

    def build(self) -> "VaultExportFile":
        return self._vault_export_file
