# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .simple_user import SimpleUser
from .task_status import TaskStatus
from .vault_export_file import VaultExportFile


class VaultTask(object):
    _types = {
        "task_id": str,
        "name": str,
        "size": str,
        "valid_days": int,
        "create_time": int,
        "extract_key": str,
        "creator": SimpleUser,
        "files": List[VaultExportFile],
        "status": TaskStatus,
    }

    def __init__(self, d=None):
        self.task_id: Optional[str] = None
        self.name: Optional[str] = None
        self.size: Optional[str] = None
        self.valid_days: Optional[int] = None
        self.create_time: Optional[int] = None
        self.extract_key: Optional[str] = None
        self.creator: Optional[SimpleUser] = None
        self.files: Optional[List[VaultExportFile]] = None
        self.status: Optional[TaskStatus] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "VaultTaskBuilder":
        return VaultTaskBuilder()


class VaultTaskBuilder(object):
    def __init__(self) -> None:
        self._vault_task = VaultTask()

    def task_id(self, task_id: str) -> "VaultTaskBuilder":
        self._vault_task.task_id = task_id
        return self

    def name(self, name: str) -> "VaultTaskBuilder":
        self._vault_task.name = name
        return self

    def size(self, size: str) -> "VaultTaskBuilder":
        self._vault_task.size = size
        return self

    def valid_days(self, valid_days: int) -> "VaultTaskBuilder":
        self._vault_task.valid_days = valid_days
        return self

    def create_time(self, create_time: int) -> "VaultTaskBuilder":
        self._vault_task.create_time = create_time
        return self

    def extract_key(self, extract_key: str) -> "VaultTaskBuilder":
        self._vault_task.extract_key = extract_key
        return self

    def creator(self, creator: SimpleUser) -> "VaultTaskBuilder":
        self._vault_task.creator = creator
        return self

    def files(self, files: List[VaultExportFile]) -> "VaultTaskBuilder":
        self._vault_task.files = files
        return self

    def status(self, status: TaskStatus) -> "VaultTaskBuilder":
        self._vault_task.status = status
        return self

    def build(self) -> "VaultTask":
        return self._vault_task
