# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .bool_rule_value import BoolRuleValue


class BooleanRuleCondition(object):
    _types = {
        "type": str,
        "boolean_conditional_values": List[BoolRuleValue],
    }

    def __init__(self, d=None):
        self.type: Optional[str] = None
        self.boolean_conditional_values: Optional[List[BoolRuleValue]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "BooleanRuleConditionBuilder":
        return BooleanRuleConditionBuilder()


class BooleanRuleConditionBuilder(object):
    def __init__(self) -> None:
        self._boolean_rule_condition = BooleanRuleCondition()

    def type(self, type: str) -> "BooleanRuleConditionBuilder":
        self._boolean_rule_condition.type = type
        return self

    def boolean_conditional_values(self,
                                   boolean_conditional_values: List[BoolRuleValue]) -> "BooleanRuleConditionBuilder":
        self._boolean_rule_condition.boolean_conditional_values = boolean_conditional_values
        return self

    def build(self) -> "BooleanRuleCondition":
        return self._boolean_rule_condition
