# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .alignment_style import AlignmentStyle
from .border_style import BorderStyle
from .cell_font_style import CellFontStyle


class CellStyle(object):
    _types = {
        "font_style": CellFontStyle,
        "border_style": BorderStyle,
        "alignment_style": AlignmentStyle,
        "wrap_strategy": str,
        "format": str,
    }

    def __init__(self, d=None):
        self.font_style: Optional[CellFontStyle] = None
        self.border_style: Optional[BorderStyle] = None
        self.alignment_style: Optional[AlignmentStyle] = None
        self.wrap_strategy: Optional[str] = None
        self.format: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CellStyleBuilder":
        return CellStyleBuilder()


class CellStyleBuilder(object):
    def __init__(self) -> None:
        self._cell_style = CellStyle()

    def font_style(self, font_style: CellFontStyle) -> "CellStyleBuilder":
        self._cell_style.font_style = font_style
        return self

    def border_style(self, border_style: BorderStyle) -> "CellStyleBuilder":
        self._cell_style.border_style = border_style
        return self

    def alignment_style(self, alignment_style: AlignmentStyle) -> "CellStyleBuilder":
        self._cell_style.alignment_style = alignment_style
        return self

    def wrap_strategy(self, wrap_strategy: str) -> "CellStyleBuilder":
        self._cell_style.wrap_strategy = wrap_strategy
        return self

    def format(self, format: str) -> "CellStyleBuilder":
        self._cell_style.format = format
        return self

    def build(self) -> "CellStyle":
        return self._cell_style
