# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .date_time import DateTime
from .file import File
from .formula import Formula
from .image import Image
from .link import Link
from .mention_document import MentionDocument
from .mention_user import MentionUser
from .reminder import Reminder
from .text import Text
from .value_element import ValueElement


class CellValue(object):
    _types = {
        "type": str,
        "text": Text,
        "mention_user": MentionUser,
        "mention_document": MentionDocument,
        "value": ValueElement,
        "date_time": DateTime,
        "file": File,
        "image": Image,
        "link": Link,
        "reminder": Reminder,
        "formula": Formula,
    }

    def __init__(self, d=None):
        self.type: Optional[str] = None
        self.text: Optional[Text] = None
        self.mention_user: Optional[MentionUser] = None
        self.mention_document: Optional[MentionDocument] = None
        self.value: Optional[ValueElement] = None
        self.date_time: Optional[DateTime] = None
        self.file: Optional[File] = None
        self.image: Optional[Image] = None
        self.link: Optional[Link] = None
        self.reminder: Optional[Reminder] = None
        self.formula: Optional[Formula] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CellValueBuilder":
        return CellValueBuilder()


class CellValueBuilder(object):
    def __init__(self) -> None:
        self._cell_value = CellValue()

    def type(self, type: str) -> "CellValueBuilder":
        self._cell_value.type = type
        return self

    def text(self, text: Text) -> "CellValueBuilder":
        self._cell_value.text = text
        return self

    def mention_user(self, mention_user: MentionUser) -> "CellValueBuilder":
        self._cell_value.mention_user = mention_user
        return self

    def mention_document(self, mention_document: MentionDocument) -> "CellValueBuilder":
        self._cell_value.mention_document = mention_document
        return self

    def value(self, value: ValueElement) -> "CellValueBuilder":
        self._cell_value.value = value
        return self

    def date_time(self, date_time: DateTime) -> "CellValueBuilder":
        self._cell_value.date_time = date_time
        return self

    def file(self, file: File) -> "CellValueBuilder":
        self._cell_value.file = file
        return self

    def image(self, image: Image) -> "CellValueBuilder":
        self._cell_value.image = image
        return self

    def link(self, link: Link) -> "CellValueBuilder":
        self._cell_value.link = link
        return self

    def reminder(self, reminder: Reminder) -> "CellValueBuilder":
        self._cell_value.reminder = reminder
        return self

    def formula(self, formula: Formula) -> "CellValueBuilder":
        self._cell_value.formula = formula
        return self

    def build(self) -> "CellValue":
        return self._cell_value
