# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .conditional_format_range import ConditionalFormatRange
from .conditional_format_rule import ConditionalFormatRule


class ConditionalFormat(object):
    _types = {
        "conditional_format_id": str,
        "conditional_format_rule": ConditionalFormatRule,
        "index": int,
        "ranges": ConditionalFormatRange,
    }

    def __init__(self, d=None):
        self.conditional_format_id: Optional[str] = None
        self.conditional_format_rule: Optional[ConditionalFormatRule] = None
        self.index: Optional[int] = None
        self.ranges: Optional[ConditionalFormatRange] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ConditionalFormatBuilder":
        return ConditionalFormatBuilder()


class ConditionalFormatBuilder(object):
    def __init__(self) -> None:
        self._conditional_format = ConditionalFormat()

    def conditional_format_id(self, conditional_format_id: str) -> "ConditionalFormatBuilder":
        self._conditional_format.conditional_format_id = conditional_format_id
        return self

    def conditional_format_rule(self, conditional_format_rule: ConditionalFormatRule) -> "ConditionalFormatBuilder":
        self._conditional_format.conditional_format_rule = conditional_format_rule
        return self

    def index(self, index: int) -> "ConditionalFormatBuilder":
        self._conditional_format.index = index
        return self

    def ranges(self, ranges: ConditionalFormatRange) -> "ConditionalFormatBuilder":
        self._conditional_format.ranges = ranges
        return self

    def build(self) -> "ConditionalFormat":
        return self._conditional_format
