# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class ConditionalFormatStyle(object):
    _types = {
        "background_color": str,
        "foreground_color": str,
        "underline": bool,
        "bold": bool,
        "italic": bool,
        "strikethrough": bool,
    }

    def __init__(self, d=None):
        self.background_color: Optional[str] = None
        self.foreground_color: Optional[str] = None
        self.underline: Optional[bool] = None
        self.bold: Optional[bool] = None
        self.italic: Optional[bool] = None
        self.strikethrough: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ConditionalFormatStyleBuilder":
        return ConditionalFormatStyleBuilder()


class ConditionalFormatStyleBuilder(object):
    def __init__(self) -> None:
        self._conditional_format_style = ConditionalFormatStyle()

    def background_color(self, background_color: str) -> "ConditionalFormatStyleBuilder":
        self._conditional_format_style.background_color = background_color
        return self

    def foreground_color(self, foreground_color: str) -> "ConditionalFormatStyleBuilder":
        self._conditional_format_style.foreground_color = foreground_color
        return self

    def underline(self, underline: bool) -> "ConditionalFormatStyleBuilder":
        self._conditional_format_style.underline = underline
        return self

    def bold(self, bold: bool) -> "ConditionalFormatStyleBuilder":
        self._conditional_format_style.bold = bold
        return self

    def italic(self, italic: bool) -> "ConditionalFormatStyleBuilder":
        self._conditional_format_style.italic = italic
        return self

    def strikethrough(self, strikethrough: bool) -> "ConditionalFormatStyleBuilder":
        self._conditional_format_style.strikethrough = strikethrough
        return self

    def build(self) -> "ConditionalFormatStyle":
        return self._conditional_format_style
