# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class DataValidationValue(object):
    _types = {
        "option_value": str,
        "option_color": str,
    }

    def __init__(self, d=None):
        self.option_value: Optional[str] = None
        self.option_color: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DataValidationValueBuilder":
        return DataValidationValueBuilder()


class DataValidationValueBuilder(object):
    def __init__(self) -> None:
        self._data_validation_value = DataValidationValue()

    def option_value(self, option_value: str) -> "DataValidationValueBuilder":
        self._data_validation_value.option_value = option_value
        return self

    def option_color(self, option_color: str) -> "DataValidationValueBuilder":
        self._data_validation_value.option_color = option_color
        return self

    def build(self) -> "DataValidationValue":
        return self._data_validation_value
