# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteSpreadsheetSheetFilterRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.spreadsheet_token: Optional[str] = None
        self.sheet_id: Optional[str] = None

    @staticmethod
    def builder() -> "DeleteSpreadsheetSheetFilterRequestBuilder":
        return DeleteSpreadsheetSheetFilterRequestBuilder()


class DeleteSpreadsheetSheetFilterRequestBuilder(object):

    def __init__(self) -> None:
        delete_spreadsheet_sheet_filter_request = DeleteSpreadsheetSheetFilterRequest()
        delete_spreadsheet_sheet_filter_request.http_method = HttpMethod.DELETE
        delete_spreadsheet_sheet_filter_request.uri = "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter"
        delete_spreadsheet_sheet_filter_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._delete_spreadsheet_sheet_filter_request: DeleteSpreadsheetSheetFilterRequest = delete_spreadsheet_sheet_filter_request

    def spreadsheet_token(self, spreadsheet_token: str) -> "DeleteSpreadsheetSheetFilterRequestBuilder":
        self._delete_spreadsheet_sheet_filter_request.spreadsheet_token = spreadsheet_token
        self._delete_spreadsheet_sheet_filter_request.paths["spreadsheet_token"] = str(spreadsheet_token)
        return self

    def sheet_id(self, sheet_id: str) -> "DeleteSpreadsheetSheetFilterRequestBuilder":
        self._delete_spreadsheet_sheet_filter_request.sheet_id = sheet_id
        self._delete_spreadsheet_sheet_filter_request.paths["sheet_id"] = str(sheet_id)
        return self

    def build(self) -> DeleteSpreadsheetSheetFilterRequest:
        return self._delete_spreadsheet_sheet_filter_request
