# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class DimensionProperties(object):
    _types = {
        "hidden": bool,
        "pixel_size": int,
    }

    def __init__(self, d=None):
        self.hidden: Optional[bool] = None
        self.pixel_size: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DimensionPropertiesBuilder":
        return DimensionPropertiesBuilder()


class DimensionPropertiesBuilder(object):
    def __init__(self) -> None:
        self._dimension_properties = DimensionProperties()

    def hidden(self, hidden: bool) -> "DimensionPropertiesBuilder":
        self._dimension_properties.hidden = hidden
        return self

    def pixel_size(self, pixel_size: int) -> "DimensionPropertiesBuilder":
        self._dimension_properties.pixel_size = pixel_size
        return self

    def build(self) -> "DimensionProperties":
        return self._dimension_properties
