# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .segment_style import SegmentStyle


class File(object):
    _types = {
        "file_token": str,
        "name": str,
        "segment_style": SegmentStyle,
    }

    def __init__(self, d=None):
        self.file_token: Optional[str] = None
        self.name: Optional[str] = None
        self.segment_style: Optional[SegmentStyle] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "FileBuilder":
        return FileBuilder()


class FileBuilder(object):
    def __init__(self) -> None:
        self._file = File()

    def file_token(self, file_token: str) -> "FileBuilder":
        self._file.file_token = file_token
        return self

    def name(self, name: str) -> "FileBuilder":
        self._file.name = name
        return self

    def segment_style(self, segment_style: SegmentStyle) -> "FileBuilder":
        self._file.segment_style = segment_style
        return self

    def build(self) -> "File":
        return self._file
