# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .find import Find


class FindSpreadsheetSheetRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.spreadsheet_token: Optional[str] = None
        self.sheet_id: Optional[str] = None
        self.request_body: Optional[Find] = None

    @staticmethod
    def builder() -> "FindSpreadsheetSheetRequestBuilder":
        return FindSpreadsheetSheetRequestBuilder()


class FindSpreadsheetSheetRequestBuilder(object):

    def __init__(self) -> None:
        find_spreadsheet_sheet_request = FindSpreadsheetSheetRequest()
        find_spreadsheet_sheet_request.http_method = HttpMethod.POST
        find_spreadsheet_sheet_request.uri = "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/find"
        find_spreadsheet_sheet_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._find_spreadsheet_sheet_request: FindSpreadsheetSheetRequest = find_spreadsheet_sheet_request

    def spreadsheet_token(self, spreadsheet_token: str) -> "FindSpreadsheetSheetRequestBuilder":
        self._find_spreadsheet_sheet_request.spreadsheet_token = spreadsheet_token
        self._find_spreadsheet_sheet_request.paths["spreadsheet_token"] = str(spreadsheet_token)
        return self

    def sheet_id(self, sheet_id: str) -> "FindSpreadsheetSheetRequestBuilder":
        self._find_spreadsheet_sheet_request.sheet_id = sheet_id
        self._find_spreadsheet_sheet_request.paths["sheet_id"] = str(sheet_id)
        return self

    def request_body(self, request_body: Find) -> "FindSpreadsheetSheetRequestBuilder":
        self._find_spreadsheet_sheet_request.request_body = request_body
        self._find_spreadsheet_sheet_request.body = request_body
        return self

    def build(self) -> FindSpreadsheetSheetRequest:
        return self._find_spreadsheet_sheet_request
