# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Formula(object):
    _types = {
        "formula": str,
        "formula_value": str,
        "affected_range": str,
    }

    def __init__(self, d=None):
        self.formula: Optional[str] = None
        self.formula_value: Optional[str] = None
        self.affected_range: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "FormulaBuilder":
        return FormulaBuilder()


class FormulaBuilder(object):
    def __init__(self) -> None:
        self._formula = Formula()

    def formula(self, formula: str) -> "FormulaBuilder":
        self._formula.formula = formula
        return self

    def formula_value(self, formula_value: str) -> "FormulaBuilder":
        self._formula.formula_value = formula_value
        return self

    def affected_range(self, affected_range: str) -> "FormulaBuilder":
        self._formula.affected_range = affected_range
        return self

    def build(self) -> "Formula":
        return self._formula
