# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .segment_style import SegmentStyle


class MentionUser(object):
    _types = {
        "name": str,
        "user_id": str,
        "notify": bool,
        "segment_style": SegmentStyle,
    }

    def __init__(self, d=None):
        self.name: Optional[str] = None
        self.user_id: Optional[str] = None
        self.notify: Optional[bool] = None
        self.segment_style: Optional[SegmentStyle] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MentionUserBuilder":
        return MentionUserBuilder()


class MentionUserBuilder(object):
    def __init__(self) -> None:
        self._mention_user = MentionUser()

    def name(self, name: str) -> "MentionUserBuilder":
        self._mention_user.name = name
        return self

    def user_id(self, user_id: str) -> "MentionUserBuilder":
        self._mention_user.user_id = user_id
        return self

    def notify(self, notify: bool) -> "MentionUserBuilder":
        self._mention_user.notify = notify
        return self

    def segment_style(self, segment_style: SegmentStyle) -> "MentionUserBuilder":
        self._mention_user.segment_style = segment_style
        return self

    def build(self) -> "MentionUser":
        return self._mention_user
