# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .merge_range import MergeRange


class MergeCell(object):
    _types = {
        "range": MergeRange,
        "merge_type": str,
    }

    def __init__(self, d=None):
        self.range: Optional[MergeRange] = None
        self.merge_type: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MergeCellBuilder":
        return MergeCellBuilder()


class MergeCellBuilder(object):
    def __init__(self) -> None:
        self._merge_cell = MergeCell()

    def range(self, range: MergeRange) -> "MergeCellBuilder":
        self._merge_cell.range = range
        return self

    def merge_type(self, merge_type: str) -> "MergeCellBuilder":
        self._merge_cell.merge_type = merge_type
        return self

    def build(self) -> "MergeCell":
        return self._merge_cell
