# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .dimension import Dimension


class MoveDimension(object):
    _types = {
        "source": Dimension,
        "destination_index": int,
    }

    def __init__(self, d=None):
        self.source: Optional[Dimension] = None
        self.destination_index: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MoveDimensionBuilder":
        return MoveDimensionBuilder()


class MoveDimensionBuilder(object):
    def __init__(self) -> None:
        self._move_dimension = MoveDimension()

    def source(self, source: Dimension) -> "MoveDimensionBuilder":
        self._move_dimension.source = source
        return self

    def destination_index(self, destination_index: int) -> "MoveDimensionBuilder":
        self._move_dimension.destination_index = destination_index
        return self

    def build(self) -> "MoveDimension":
        return self._move_dimension
