# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .data_validation_rule import DataValidationRule


class PatchDataValidation(object):
    _types = {
        "data_validation_rule": DataValidationRule,
        "strict": bool,
        "help_text": str,
    }

    def __init__(self, d=None):
        self.data_validation_rule: Optional[DataValidationRule] = None
        self.strict: Optional[bool] = None
        self.help_text: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PatchDataValidationBuilder":
        return PatchDataValidationBuilder()


class PatchDataValidationBuilder(object):
    def __init__(self) -> None:
        self._patch_data_validation = PatchDataValidation()

    def data_validation_rule(self, data_validation_rule: DataValidationRule) -> "PatchDataValidationBuilder":
        self._patch_data_validation.data_validation_rule = data_validation_rule
        return self

    def strict(self, strict: bool) -> "PatchDataValidationBuilder":
        self._patch_data_validation.strict = strict
        return self

    def help_text(self, help_text: str) -> "PatchDataValidationBuilder":
        self._patch_data_validation.help_text = help_text
        return self

    def build(self) -> "PatchDataValidation":
        return self._patch_data_validation
