# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .float_image import FloatImage


class PatchSpreadsheetSheetFloatImageRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.spreadsheet_token: Optional[str] = None
        self.sheet_id: Optional[str] = None
        self.float_image_id: Optional[str] = None
        self.request_body: Optional[FloatImage] = None

    @staticmethod
    def builder() -> "PatchSpreadsheetSheetFloatImageRequestBuilder":
        return PatchSpreadsheetSheetFloatImageRequestBuilder()


class PatchSpreadsheetSheetFloatImageRequestBuilder(object):

    def __init__(self) -> None:
        patch_spreadsheet_sheet_float_image_request = PatchSpreadsheetSheetFloatImageRequest()
        patch_spreadsheet_sheet_float_image_request.http_method = HttpMethod.PATCH
        patch_spreadsheet_sheet_float_image_request.uri = "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/float_images/:float_image_id"
        patch_spreadsheet_sheet_float_image_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._patch_spreadsheet_sheet_float_image_request: PatchSpreadsheetSheetFloatImageRequest = patch_spreadsheet_sheet_float_image_request

    def spreadsheet_token(self, spreadsheet_token: str) -> "PatchSpreadsheetSheetFloatImageRequestBuilder":
        self._patch_spreadsheet_sheet_float_image_request.spreadsheet_token = spreadsheet_token
        self._patch_spreadsheet_sheet_float_image_request.paths["spreadsheet_token"] = str(spreadsheet_token)
        return self

    def sheet_id(self, sheet_id: str) -> "PatchSpreadsheetSheetFloatImageRequestBuilder":
        self._patch_spreadsheet_sheet_float_image_request.sheet_id = sheet_id
        self._patch_spreadsheet_sheet_float_image_request.paths["sheet_id"] = str(sheet_id)
        return self

    def float_image_id(self, float_image_id: str) -> "PatchSpreadsheetSheetFloatImageRequestBuilder":
        self._patch_spreadsheet_sheet_float_image_request.float_image_id = float_image_id
        self._patch_spreadsheet_sheet_float_image_request.paths["float_image_id"] = str(float_image_id)
        return self

    def request_body(self, request_body: FloatImage) -> "PatchSpreadsheetSheetFloatImageRequestBuilder":
        self._patch_spreadsheet_sheet_float_image_request.request_body = request_body
        self._patch_spreadsheet_sheet_float_image_request.body = request_body
        return self

    def build(self) -> PatchSpreadsheetSheetFloatImageRequest:
        return self._patch_spreadsheet_sheet_float_image_request
