# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .segment_style_style import SegmentStyleStyle


class SegmentStyle(object):
    _types = {
        "affected_text": str,
        "style": SegmentStyleStyle,
    }

    def __init__(self, d=None):
        self.affected_text: Optional[str] = None
        self.style: Optional[SegmentStyleStyle] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SegmentStyleBuilder":
        return SegmentStyleBuilder()


class SegmentStyleBuilder(object):
    def __init__(self) -> None:
        self._segment_style = SegmentStyle()

    def affected_text(self, affected_text: str) -> "SegmentStyleBuilder":
        self._segment_style.affected_text = affected_text
        return self

    def style(self, style: SegmentStyleStyle) -> "SegmentStyleBuilder":
        self._segment_style.style = style
        return self

    def build(self) -> "SegmentStyle":
        return self._segment_style
