# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class SegmentStyleStyle(object):
    _types = {
        "bold": bool,
        "italic": bool,
        "strike_through": bool,
        "underline": bool,
        "fore_color": str,
        "font_size": int,
    }

    def __init__(self, d=None):
        self.bold: Optional[bool] = None
        self.italic: Optional[bool] = None
        self.strike_through: Optional[bool] = None
        self.underline: Optional[bool] = None
        self.fore_color: Optional[str] = None
        self.font_size: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SegmentStyleStyleBuilder":
        return SegmentStyleStyleBuilder()


class SegmentStyleStyleBuilder(object):
    def __init__(self) -> None:
        self._segment_style_style = SegmentStyleStyle()

    def bold(self, bold: bool) -> "SegmentStyleStyleBuilder":
        self._segment_style_style.bold = bold
        return self

    def italic(self, italic: bool) -> "SegmentStyleStyleBuilder":
        self._segment_style_style.italic = italic
        return self

    def strike_through(self, strike_through: bool) -> "SegmentStyleStyleBuilder":
        self._segment_style_style.strike_through = strike_through
        return self

    def underline(self, underline: bool) -> "SegmentStyleStyleBuilder":
        self._segment_style_style.underline = underline
        return self

    def fore_color(self, fore_color: str) -> "SegmentStyleStyleBuilder":
        self._segment_style_style.fore_color = fore_color
        return self

    def font_size(self, font_size: int) -> "SegmentStyleStyleBuilder":
        self._segment_style_style.font_size = font_size
        return self

    def build(self) -> "SegmentStyleStyle":
        return self._segment_style_style
