# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Spreadsheet(object):
    _types = {
        "title": str,
        "folder_token": str,
        "url": str,
        "spreadsheet_token": str,
    }

    def __init__(self, d=None):
        self.title: Optional[str] = None
        self.folder_token: Optional[str] = None
        self.url: Optional[str] = None
        self.spreadsheet_token: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SpreadsheetBuilder":
        return SpreadsheetBuilder()


class SpreadsheetBuilder(object):
    def __init__(self) -> None:
        self._spreadsheet = Spreadsheet()

    def title(self, title: str) -> "SpreadsheetBuilder":
        self._spreadsheet.title = title
        return self

    def folder_token(self, folder_token: str) -> "SpreadsheetBuilder":
        self._spreadsheet.folder_token = folder_token
        return self

    def url(self, url: str) -> "SpreadsheetBuilder":
        self._spreadsheet.url = url
        return self

    def spreadsheet_token(self, spreadsheet_token: str) -> "SpreadsheetBuilder":
        self._spreadsheet.spreadsheet_token = spreadsheet_token
        return self

    def build(self) -> "Spreadsheet":
        return self._spreadsheet
