# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .segment_style import SegmentStyle


class Text(object):
    _types = {
        "text": str,
        "segment_style": SegmentStyle,
    }

    def __init__(self, d=None):
        self.text: Optional[str] = None
        self.segment_style: Optional[SegmentStyle] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TextBuilder":
        return TextBuilder()


class TextBuilder(object):
    def __init__(self) -> None:
        self._text = Text()

    def text(self, text: str) -> "TextBuilder":
        self._text.text = text
        return self

    def segment_style(self, segment_style: SegmentStyle) -> "TextBuilder":
        self._text.segment_style = segment_style
        return self

    def build(self) -> "Text":
        return self._text
