# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .update_sheet_filter import UpdateSheetFilter


class UpdateSpreadsheetSheetFilterRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.spreadsheet_token: Optional[str] = None
        self.sheet_id: Optional[str] = None
        self.request_body: Optional[UpdateSheetFilter] = None

    @staticmethod
    def builder() -> "UpdateSpreadsheetSheetFilterRequestBuilder":
        return UpdateSpreadsheetSheetFilterRequestBuilder()


class UpdateSpreadsheetSheetFilterRequestBuilder(object):

    def __init__(self) -> None:
        update_spreadsheet_sheet_filter_request = UpdateSpreadsheetSheetFilterRequest()
        update_spreadsheet_sheet_filter_request.http_method = HttpMethod.PUT
        update_spreadsheet_sheet_filter_request.uri = "/open-apis/sheets/v3/spreadsheets/:spreadsheet_token/sheets/:sheet_id/filter"
        update_spreadsheet_sheet_filter_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._update_spreadsheet_sheet_filter_request: UpdateSpreadsheetSheetFilterRequest = update_spreadsheet_sheet_filter_request

    def spreadsheet_token(self, spreadsheet_token: str) -> "UpdateSpreadsheetSheetFilterRequestBuilder":
        self._update_spreadsheet_sheet_filter_request.spreadsheet_token = spreadsheet_token
        self._update_spreadsheet_sheet_filter_request.paths["spreadsheet_token"] = str(spreadsheet_token)
        return self

    def sheet_id(self, sheet_id: str) -> "UpdateSpreadsheetSheetFilterRequestBuilder":
        self._update_spreadsheet_sheet_filter_request.sheet_id = sheet_id
        self._update_spreadsheet_sheet_filter_request.paths["sheet_id"] = str(sheet_id)
        return self

    def request_body(self, request_body: UpdateSheetFilter) -> "UpdateSpreadsheetSheetFilterRequestBuilder":
        self._update_spreadsheet_sheet_filter_request.request_body = request_body
        self._update_spreadsheet_sheet_filter_request.body = request_body
        return self

    def build(self) -> UpdateSpreadsheetSheetFilterRequest:
        return self._update_spreadsheet_sheet_filter_request
