# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_spreadsheet_sheet_filter_request import CreateSpreadsheetSheetFilterRequest
from ..model.create_spreadsheet_sheet_filter_response import CreateSpreadsheetSheetFilterResponse
from ..model.delete_spreadsheet_sheet_filter_request import DeleteSpreadsheetSheetFilterRequest
from ..model.delete_spreadsheet_sheet_filter_response import DeleteSpreadsheetSheetFilterResponse
from ..model.get_spreadsheet_sheet_filter_request import GetSpreadsheetSheetFilterRequest
from ..model.get_spreadsheet_sheet_filter_response import GetSpreadsheetSheetFilterResponse
from ..model.update_spreadsheet_sheet_filter_request import UpdateSpreadsheetSheetFilterRequest
from ..model.update_spreadsheet_sheet_filter_response import UpdateSpreadsheetSheetFilterResponse


class SpreadsheetSheetFilter(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateSpreadsheetSheetFilterRequest,
               option: Optional[RequestOption] = None) -> CreateSpreadsheetSheetFilterResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateSpreadsheetSheetFilterResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                        CreateSpreadsheetSheetFilterResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateSpreadsheetSheetFilterRequest,
                      option: Optional[RequestOption] = None) -> CreateSpreadsheetSheetFilterResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateSpreadsheetSheetFilterResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                        CreateSpreadsheetSheetFilterResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteSpreadsheetSheetFilterRequest,
               option: Optional[RequestOption] = None) -> DeleteSpreadsheetSheetFilterResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteSpreadsheetSheetFilterResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                        DeleteSpreadsheetSheetFilterResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteSpreadsheetSheetFilterRequest,
                      option: Optional[RequestOption] = None) -> DeleteSpreadsheetSheetFilterResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteSpreadsheetSheetFilterResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                        DeleteSpreadsheetSheetFilterResponse)
        response.raw = resp

        return response

    def get(self, request: GetSpreadsheetSheetFilterRequest,
            option: Optional[RequestOption] = None) -> GetSpreadsheetSheetFilterResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetSpreadsheetSheetFilterResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     GetSpreadsheetSheetFilterResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetSpreadsheetSheetFilterRequest,
                   option: Optional[RequestOption] = None) -> GetSpreadsheetSheetFilterResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetSpreadsheetSheetFilterResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     GetSpreadsheetSheetFilterResponse)
        response.raw = resp

        return response

    def update(self, request: UpdateSpreadsheetSheetFilterRequest,
               option: Optional[RequestOption] = None) -> UpdateSpreadsheetSheetFilterResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UpdateSpreadsheetSheetFilterResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                        UpdateSpreadsheetSheetFilterResponse)
        response.raw = resp

        return response

    async def aupdate(self, request: UpdateSpreadsheetSheetFilterRequest,
                      option: Optional[RequestOption] = None) -> UpdateSpreadsheetSheetFilterResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UpdateSpreadsheetSheetFilterResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                        UpdateSpreadsheetSheetFilterResponse)
        response.raw = resp

        return response
