# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class FileConfig(object):
    _types = {
        "file_id": str,
        "format": str,
        "engine_type": str,
    }

    def __init__(self, d=None):
        self.file_id: Optional[str] = None
        self.format: Optional[str] = None
        self.engine_type: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "FileConfigBuilder":
        return FileConfigBuilder()


class FileConfigBuilder(object):
    def __init__(self) -> None:
        self._file_config = FileConfig()

    def file_id(self, file_id: str) -> "FileConfigBuilder":
        self._file_config.file_id = file_id
        return self

    def format(self, format: str) -> "FileConfigBuilder":
        self._file_config.format = format
        return self

    def engine_type(self, engine_type: str) -> "FileConfigBuilder":
        self._file_config.engine_type = engine_type
        return self

    def build(self) -> "FileConfig":
        return self._file_config
