# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .stream_recognize_speech_request_body import StreamRecognizeSpeechRequestBody


class StreamRecognizeSpeechRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[StreamRecognizeSpeechRequestBody] = None

    @staticmethod
    def builder() -> "StreamRecognizeSpeechRequestBuilder":
        return StreamRecognizeSpeechRequestBuilder()


class StreamRecognizeSpeechRequestBuilder(object):

    def __init__(self) -> None:
        stream_recognize_speech_request = StreamRecognizeSpeechRequest()
        stream_recognize_speech_request.http_method = HttpMethod.POST
        stream_recognize_speech_request.uri = "/open-apis/speech_to_text/v1/speech/stream_recognize"
        stream_recognize_speech_request.token_types = {AccessTokenType.TENANT}
        self._stream_recognize_speech_request: StreamRecognizeSpeechRequest = stream_recognize_speech_request

    def request_body(self, request_body: StreamRecognizeSpeechRequestBody) -> "StreamRecognizeSpeechRequestBuilder":
        self._stream_recognize_speech_request.request_body = request_body
        self._stream_recognize_speech_request.body = request_body
        return self

    def build(self) -> StreamRecognizeSpeechRequest:
        return self._stream_recognize_speech_request
