# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class Collaborator(object):
    _types = {
        "id": str,
        "id_list": List[str],
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.id_list: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CollaboratorBuilder":
        return CollaboratorBuilder()


class CollaboratorBuilder(object):
    def __init__(self) -> None:
        self._collaborator = Collaborator()

    def id(self, id: str) -> "CollaboratorBuilder":
        self._collaborator.id = id
        return self

    def id_list(self, id_list: List[str]) -> "CollaboratorBuilder":
        self._collaborator.id_list = id_list
        return self

    def build(self) -> "Collaborator":
        return self._collaborator
