# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteTaskCollaboratorRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.task_id: Optional[str] = None
        self.collaborator_id: Optional[str] = None

    @staticmethod
    def builder() -> "DeleteTaskCollaboratorRequestBuilder":
        return DeleteTaskCollaboratorRequestBuilder()


class DeleteTaskCollaboratorRequestBuilder(object):

    def __init__(self) -> None:
        delete_task_collaborator_request = DeleteTaskCollaboratorRequest()
        delete_task_collaborator_request.http_method = HttpMethod.DELETE
        delete_task_collaborator_request.uri = "/open-apis/task/v1/tasks/:task_id/collaborators/:collaborator_id"
        delete_task_collaborator_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._delete_task_collaborator_request: DeleteTaskCollaboratorRequest = delete_task_collaborator_request

    def user_id_type(self, user_id_type: str) -> "DeleteTaskCollaboratorRequestBuilder":
        self._delete_task_collaborator_request.user_id_type = user_id_type
        self._delete_task_collaborator_request.add_query("user_id_type", user_id_type)
        return self

    def task_id(self, task_id: str) -> "DeleteTaskCollaboratorRequestBuilder":
        self._delete_task_collaborator_request.task_id = task_id
        self._delete_task_collaborator_request.paths["task_id"] = str(task_id)
        return self

    def collaborator_id(self, collaborator_id: str) -> "DeleteTaskCollaboratorRequestBuilder":
        self._delete_task_collaborator_request.collaborator_id = collaborator_id
        self._delete_task_collaborator_request.paths["collaborator_id"] = str(collaborator_id)
        return self

    def build(self) -> DeleteTaskCollaboratorRequest:
        return self._delete_task_collaborator_request
