# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteTaskCommentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.task_id: Optional[str] = None
        self.comment_id: Optional[int] = None

    @staticmethod
    def builder() -> "DeleteTaskCommentRequestBuilder":
        return DeleteTaskCommentRequestBuilder()


class DeleteTaskCommentRequestBuilder(object):

    def __init__(self) -> None:
        delete_task_comment_request = DeleteTaskCommentRequest()
        delete_task_comment_request.http_method = HttpMethod.DELETE
        delete_task_comment_request.uri = "/open-apis/task/v1/tasks/:task_id/comments/:comment_id"
        delete_task_comment_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._delete_task_comment_request: DeleteTaskCommentRequest = delete_task_comment_request

    def task_id(self, task_id: str) -> "DeleteTaskCommentRequestBuilder":
        self._delete_task_comment_request.task_id = task_id
        self._delete_task_comment_request.paths["task_id"] = str(task_id)
        return self

    def comment_id(self, comment_id: int) -> "DeleteTaskCommentRequestBuilder":
        self._delete_task_comment_request.comment_id = comment_id
        self._delete_task_comment_request.paths["comment_id"] = str(comment_id)
        return self

    def build(self) -> DeleteTaskCommentRequest:
        return self._delete_task_comment_request
