# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteTaskFollowerRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.task_id: Optional[str] = None
        self.follower_id: Optional[str] = None

    @staticmethod
    def builder() -> "DeleteTaskFollowerRequestBuilder":
        return DeleteTaskFollowerRequestBuilder()


class DeleteTaskFollowerRequestBuilder(object):

    def __init__(self) -> None:
        delete_task_follower_request = DeleteTaskFollowerRequest()
        delete_task_follower_request.http_method = HttpMethod.DELETE
        delete_task_follower_request.uri = "/open-apis/task/v1/tasks/:task_id/followers/:follower_id"
        delete_task_follower_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._delete_task_follower_request: DeleteTaskFollowerRequest = delete_task_follower_request

    def user_id_type(self, user_id_type: str) -> "DeleteTaskFollowerRequestBuilder":
        self._delete_task_follower_request.user_id_type = user_id_type
        self._delete_task_follower_request.add_query("user_id_type", user_id_type)
        return self

    def task_id(self, task_id: str) -> "DeleteTaskFollowerRequestBuilder":
        self._delete_task_follower_request.task_id = task_id
        self._delete_task_follower_request.paths["task_id"] = str(task_id)
        return self

    def follower_id(self, follower_id: str) -> "DeleteTaskFollowerRequestBuilder":
        self._delete_task_follower_request.follower_id = follower_id
        self._delete_task_follower_request.paths["follower_id"] = str(follower_id)
        return self

    def build(self) -> DeleteTaskFollowerRequest:
        return self._delete_task_follower_request
