# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .collaborator import Collaborator


class ListTaskCollaboratorResponseBody(object):
    _types = {
        "items": List[Collaborator],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.items: Optional[List[Collaborator]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListTaskCollaboratorResponseBodyBuilder":
        return ListTaskCollaboratorResponseBodyBuilder()


class ListTaskCollaboratorResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_task_collaborator_response_body = ListTaskCollaboratorResponseBody()

    def items(self, items: List[Collaborator]) -> "ListTaskCollaboratorResponseBodyBuilder":
        self._list_task_collaborator_response_body.items = items
        return self

    def page_token(self, page_token: str) -> "ListTaskCollaboratorResponseBodyBuilder":
        self._list_task_collaborator_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "ListTaskCollaboratorResponseBodyBuilder":
        self._list_task_collaborator_response_body.has_more = has_more
        return self

    def build(self) -> "ListTaskCollaboratorResponseBody":
        return self._list_task_collaborator_response_body
