# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .comment import Comment


class ListTaskCommentResponseBody(object):
    _types = {
        "items": List[Comment],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.items: Optional[List[Comment]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListTaskCommentResponseBodyBuilder":
        return ListTaskCommentResponseBodyBuilder()


class ListTaskCommentResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_task_comment_response_body = ListTaskCommentResponseBody()

    def items(self, items: List[Comment]) -> "ListTaskCommentResponseBodyBuilder":
        self._list_task_comment_response_body.items = items
        return self

    def page_token(self, page_token: str) -> "ListTaskCommentResponseBodyBuilder":
        self._list_task_comment_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "ListTaskCommentResponseBodyBuilder":
        self._list_task_comment_response_body.has_more = has_more
        return self

    def build(self) -> "ListTaskCommentResponseBody":
        return self._list_task_comment_response_body
