# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .reminder import Reminder


class ListTaskReminderResponseBody(object):
    _types = {
        "items": List[Reminder],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.items: Optional[List[Reminder]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListTaskReminderResponseBodyBuilder":
        return ListTaskReminderResponseBodyBuilder()


class ListTaskReminderResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_task_reminder_response_body = ListTaskReminderResponseBody()

    def items(self, items: List[Reminder]) -> "ListTaskReminderResponseBodyBuilder":
        self._list_task_reminder_response_body.items = items
        return self

    def page_token(self, page_token: str) -> "ListTaskReminderResponseBodyBuilder":
        self._list_task_reminder_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "ListTaskReminderResponseBodyBuilder":
        self._list_task_reminder_response_body.has_more = has_more
        return self

    def build(self) -> "ListTaskReminderResponseBody":
        return self._list_task_reminder_response_body
