# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .patch_task_request_body import PatchTaskRequestBody


class PatchTaskRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.task_id: Optional[str] = None
        self.request_body: Optional[PatchTaskRequestBody] = None

    @staticmethod
    def builder() -> "PatchTaskRequestBuilder":
        return PatchTaskRequestBuilder()


class PatchTaskRequestBuilder(object):

    def __init__(self) -> None:
        patch_task_request = PatchTaskRequest()
        patch_task_request.http_method = HttpMethod.PATCH
        patch_task_request.uri = "/open-apis/task/v1/tasks/:task_id"
        patch_task_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._patch_task_request: PatchTaskRequest = patch_task_request

    def user_id_type(self, user_id_type: str) -> "PatchTaskRequestBuilder":
        self._patch_task_request.user_id_type = user_id_type
        self._patch_task_request.add_query("user_id_type", user_id_type)
        return self

    def task_id(self, task_id: str) -> "PatchTaskRequestBuilder":
        self._patch_task_request.task_id = task_id
        self._patch_task_request.paths["task_id"] = str(task_id)
        return self

    def request_body(self, request_body: PatchTaskRequestBody) -> "PatchTaskRequestBuilder":
        self._patch_task_request.request_body = request_body
        self._patch_task_request.body = request_body
        return self

    def build(self) -> PatchTaskRequest:
        return self._patch_task_request
